#Handle new players
execute as @a if score @s astro_game.playtime matches ..200 run function astro_game:lobby/handle_new_player

#Handle navigate button
execute as @e[tag=navigate_button] run function astro_game:lobby/computer/handle_navigate_button

#Handle start button
execute as @e[tag=start_button] run function astro_game:lobby/computer/handle_start_button

#Handle credits
execute as @e[tag=credits] run function astro_game:lobby/credits/handle_credits

#Handle spectator hologram
execute as @e[tag=spectator_hologram] run function astro_game:lobby/spectator_hologram/handle

#Handle suit pads
function astro_game:lobby/suits/handle_equips

#Handle lobby titles
# Handle red gate (Overrides base title)
execute as @a[tag=!white_suit,tag=!black_suit,tag=!orange_suit] run function astro_game:lobby/red_gate/handle

# set base title
execute if score running astro_game.persistent matches 0 at @e[tag=buttons,limit=1] as @a[tag=suitted] if entity @s[distance=16..] run title @s actionbar [{text:"\uF837",font:"al",type:"text"}]
# Use control title
execute if score running astro_game.persistent matches 0 at @e[tag=buttons,limit=1] as @a[tag=suitted] if entity @s[distance=..14] run title @s actionbar [{text:"\uF83E",font:"al",type:"text"},{font:"default",translate:"space.-1",type:"translatable"},{text:"\uF83F",font:"al",type:"text"}]

#Effects
effect give @a minecraft:slow_falling infinite 1 true
effect give @a minecraft:resistance infinite 10 true
effect give @a minecraft:weakness infinite 10 true

#Handle spectators
gamemode spectator @a[tag=spectator]
execute unless entity @a[tag=controller] as @a[tag=spectator] run function astro_game:lobby/quit_spectating
execute as @a[tag=spectator] run spectate @a[tag=controller,limit=1] @s

bossbar set astro_game:spectators players @a[tag=spectator]

execute as @a[tag=spectator] if score @s astro_game.sneaks matches 1.. run function astro_game:lobby/quit_spectating
execute as @a[tag=!spectator] if score @s astro_game.sneaks matches 1.. run scoreboard players reset @s astro_game.sneaks

gamemode adventure @a[tag=!spectator,tag=!admin]